local t = Def.ActorFrame{}
local function GetElementPosX(self,element) return element:GetX() end
local function GetElementPosY(self,element) return element:GetY() end

local Player = MetroQuad.Global.ModPanel.Player
local State = GAMESTATE:GetPlayerState(Player)
local Options = State:GetPlayerOptionsString(0)

local AbleToMoveLeft = 0
local AbleToMoveRight = 2
local AbleToMoveUp = 0
local AbleToMoveDown = 4

local MaxDots = 1
local MaxChars = 4
local Append = "-"
local Text = ""
local Key = ""
local ModPanelTitle = "NOTE SIZE"
local ElementX = (Player == PLAYER_1 and CenterX()-284) or CenterX()+284
local ButtonX = (Player == PLAYER_1 and 91) or 659
local ButtonY = 228

NumPadSettings = {
	MaxValue = MetroQuad.Global.ModPanel.NoteSizeMaxValue,
}

t[#t+1] = LoadActor(THEME:GetPathS("","Common Start"))..{
	CodeMessageCommand=function(self,param)
		if param.PlayerNumber == Player then
			if param.Name == "Start" then
				self:play()
			end
		end
	end;
};

t[#t+1] = LoadActor(THEME:GetPathS("","Common Value"))..{
	CodeMessageCommand=function(self,param)
		if param.PlayerNumber == Player then
			if param.Name == "Left" then
				if AbleToMoveLeft > 0 then
					self:play()
				end
			end
			if param.Name == "Right" then
				if AbleToMoveRight > 0 then
					self:play()
				end
			end
			if param.Name == "Up" then
				if AbleToMoveUp > 0 then
					self:play()
				end
			end
			if param.Name == "Down" then
				if AbleToMoveDown > 0 then
					self:play()
				end
			end
		end
	end;
};

t[#t+1] = Def.ActorFrame{
	CodeMessageCommand=function(self,param)
		local c = self:GetChildren();
		local xPos = GetElementPosX(self,c.Cursor)
		local yPos = GetElementPosY(self,c.Cursor)
		if param.PlayerNumber == Player then
			if param.Name == "Start" then
				if Text == "" then Text = Append end
				if xPos == ButtonX and yPos == ButtonY then
					Key = 7 Text = Text .. Key c.InputText:settext(Text)
					if tonumber((Text:gsub(Append,""))) > NumPadSettings.MaxValue then
						c.InputText:settext(Append..NumPadSettings.MaxValue)
						Text = c.InputText:GetText()
					end
				end
				if xPos == ButtonX+52 and yPos == ButtonY then
					Key = 8 Text = Text .. Key c.InputText:settext(Text)
					if tonumber((Text:gsub(Append,""))) > NumPadSettings.MaxValue then
						c.InputText:settext(Append..NumPadSettings.MaxValue)
						Text = c.InputText:GetText()
					end
				end
				if xPos == ButtonX+52*2 and yPos == ButtonY then
					Key = 9 Text = Text .. Key c.InputText:settext(Text)
					if tonumber((Text:gsub(Append,""))) > NumPadSettings.MaxValue then
						c.InputText:settext(Append..NumPadSettings.MaxValue)
						Text = c.InputText:GetText()
					end
				end
				if xPos == ButtonX and yPos == ButtonY+28 then
					Key = 4 Text = Text .. Key c.InputText:settext(Text)
					if tonumber((Text:gsub(Append,""))) > NumPadSettings.MaxValue then
						c.InputText:settext(Append..NumPadSettings.MaxValue)
						Text = c.InputText:GetText()
					end
				end
				if xPos == ButtonX+52 and yPos == ButtonY+28 then
					Key = 5 Text = Text .. Key c.InputText:settext(Text)
					if tonumber((Text:gsub(Append,""))) > NumPadSettings.MaxValue then
						c.InputText:settext(Append..NumPadSettings.MaxValue)
						Text = c.InputText:GetText()
					end
				end
				if xPos == ButtonX+52*2 and yPos == ButtonY+28 then
					Key = 6 Text = Text .. Key c.InputText:settext(Text)
					if tonumber((Text:gsub(SpeedMod,""))) > NumPadSettings.MaxValue then
						c.InputText:settext(SpeedMod..NumPadSettings.MaxValue)
						Text = c.InputText:GetText()
					end
				end
				if xPos == ButtonX and yPos == ButtonY+28*2 then
					Key = 1 Text = Text .. Key c.InputText:settext(Text)
					if tonumber((Text:gsub(Append,""))) > NumPadSettings.MaxValue then
						c.InputText:settext(Append..NumPadSettings.MaxValue)
						Text = c.InputText:GetText()
					end
				end
				if xPos == ButtonX+52 and yPos == ButtonY+28*2 then
					Key = 2 Text = Text .. Key c.InputText:settext(Text)
					if tonumber((Text:gsub(Append,""))) > NumPadSettings.MaxValue then
						c.InputText:settext(Append..NumPadSettings.MaxValue)
						Text = c.InputText:GetText()
					end
				end
				if xPos == ButtonX+52*2 and yPos == ButtonY+28*2 then
					Key = 3 Text = Text .. Key c.InputText:settext(Text)
					if tonumber((Text:gsub(Append,""))) > NumPadSettings.MaxValue then
						c.InputText:settext(Append..NumPadSettings.MaxValue)
						Text = c.InputText:GetText()
					end
				end
				if xPos == ButtonX and yPos == ButtonY+28*3 then
					Text = "" c.InputText:settext(Text)
				end
				if xPos == ButtonX+52 and yPos == ButtonY+28*3 then
					Key = 0 Text = Text .. Key c.InputText:settext(Text)
					if tonumber((Text:gsub(Append,""))) > NumPadSettings.MaxValue then
						c.InputText:settext(Append..NumPadSettings.MaxValue)
						Text = c.InputText:GetText()
					end
				end
				if xPos == ButtonX+52*2 and yPos == ButtonY+28*3 then
					Text = Text:sub(1, -2)
					c.InputText:settext(Text)
				end
				if xPos == ButtonX and yPos == ButtonY+28*4 then
					if c.InputText:GetText() == "" then
						SCREENMAN:SystemMessage("ERROR: No Note Size entered.")
					else
						State:SetPlayerOptions(0, Options .. ", ".. Text:gsub(Append,"") .. " % Mini")
						SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen")
						MESSAGEMAN:Broadcast("NoteSizeChanged")
					end
				end
				if xPos == ButtonX+52 and yPos == ButtonY+28*4 then
					Text = math.random(10,NumPadSettings.MaxValue) c.InputText:settext(Append..Text) Text = c.InputText:GetText()
				end
				if xPos == ButtonX+52*2 and yPos == ButtonY+28*4 then
					SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen")
				end
			end
		end
	end;
	
	Def.Quad{
		Name="Cursor";
		InitCommand=cmd(x,ElementX-52;y,Top()+228;zoomto,46,20;valign,0;diffuse,PlayerColor(Player));
		CodeMessageCommand=function(self,param)
			if param.PlayerNumber == Player then
				if param.Name == "Left" then
					if AbleToMoveLeft > 0 then
						self:addx(-52)
						AbleToMoveLeft = AbleToMoveLeft - 1
						AbleToMoveRight = AbleToMoveRight + 1
					end
				end
				if param.Name == "Right" then
					if AbleToMoveRight > 0 then
						self:addx(52)
						AbleToMoveLeft = AbleToMoveLeft + 1
						AbleToMoveRight = AbleToMoveRight - 1
					end
				end
				if param.Name == "Up" then
					if AbleToMoveUp > 0 then
						self:addy(-24-4)
						AbleToMoveUp = AbleToMoveUp - 1
						AbleToMoveDown = AbleToMoveDown + 1
					end
				end
				if param.Name == "Down" then
					if AbleToMoveDown > 0 then
						self:addy(24+4)
						AbleToMoveUp = AbleToMoveUp + 1
						AbleToMoveDown = AbleToMoveDown - 1
					end
				end
			end
		end;
	};
	
	CommonNormal()..{Text=ModPanelTitle; InitCommand=cmd(xy,ElementX,Top()+184;valign,0;zoom,0.5;);};
	CommonNormal()..{Name="InputText"; InitCommand=cmd(draworder,1;xy,ElementX,Top()+204;zoom,0.6;valign,0;diffuse,PlayerColor(Player));};
	
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX;y,CenterY()+33;zoomto,172,196;diffuse,color(LoadFile("ThemeColor.cfg","Settings")));};
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX;y,CenterY()+33;zoomto,164,188;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2.5));};
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX;y,Top()+200;zoomto,100,20;valign,0;diffuse,Black();diffusealpha,0.5);};
	
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX-52;y,Top()+228;zoomto,46,20;valign,0;diffuse,Black();diffusealpha,0.5);};
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX;y,Top()+228;zoomto,46,20;valign,0;diffuse,Black();diffusealpha,0.5);};
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX+52;y,Top()+228;zoomto,46,20;valign,0;diffuse,Black();diffusealpha,0.5);};
	
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX-52;y,Top()+228+28;zoomto,46,20;valign,0;diffuse,Black();diffusealpha,0.5);};
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX;y,Top()+228+28;zoomto,46,20;valign,0;diffuse,Black();diffusealpha,0.5);};
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX+52;y,Top()+228+28;zoomto,46,20;valign,0;diffuse,Black();diffusealpha,0.5);};
	
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX-52;y,Top()+228+28*2;zoomto,46,20;valign,0;diffuse,Black();diffusealpha,0.5);};
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX;y,Top()+228+28*2;zoomto,46,20;valign,0;diffuse,Black();diffusealpha,0.5);};
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX+52;y,Top()+228+28*2;zoomto,46,20;valign,0;diffuse,Black();diffusealpha,0.5);};
	
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX-52;y,Top()+228+28*3;zoomto,46,20;valign,0;diffuse,Black();diffusealpha,0.5);};
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX;y,Top()+228+28*3;zoomto,46,20;valign,0;diffuse,Black();diffusealpha,0.5);};
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX+52;y,Top()+228+28*3;zoomto,46,20;valign,0;diffuse,Black();diffusealpha,0.5);};
	
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX-52;y,Top()+228+28*4;zoomto,46,20;valign,0;diffuse,Green();diffusealpha,0.5);};
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX;y,Top()+228+28*4;zoomto,46,20;valign,0;diffuse,(SpeedMod == "X" and Black() or Yellow());diffusealpha,0.5);};
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX+52;y,Top()+228+28*4;zoomto,46,20;valign,0;diffuse,Red();diffusealpha,0.5);};
	
	CommonNormal()..{Text="7"; InitCommand=cmd(xy,ElementX-52,Top()+228+4;zoom,0.5;valign,0);};
	CommonNormal()..{Text="8"; InitCommand=cmd(xy,ElementX,Top()+228+4;zoom,0.5;valign,0);};
	CommonNormal()..{Text="9"; InitCommand=cmd(xy,ElementX+52,Top()+228+4;zoom,0.5;valign,0);};
	
	CommonNormal()..{Text="4"; InitCommand=cmd(xy,ElementX-52,Top()+228+24+4*2;zoom,0.5;valign,0);};
	CommonNormal()..{Text="5"; InitCommand=cmd(xy,ElementX,Top()+228+24+4*2;zoom,0.5;valign,0);};
	CommonNormal()..{Text="6"; InitCommand=cmd(xy,ElementX+52,Top()+228+24+4*2;zoom,0.5;valign,0);};
	
	CommonNormal()..{Text="1"; InitCommand=cmd(xy,ElementX-52,Top()+228+24*2+4*3;zoom,0.5;valign,0);};
	CommonNormal()..{Text="2"; InitCommand=cmd(xy,ElementX,Top()+228+24*2+4*3;zoom,0.5;valign,0);};
	CommonNormal()..{Text="3"; InitCommand=cmd(xy,ElementX+52,Top()+228+24*2+4*3;zoom,0.5;valign,0);};
	
	CommonNormal()..{Text="CLEAR"; InitCommand=cmd(xy,ElementX-52,Top()+228+24*3+4*4;zoom,0.5;valign,0;maxwidth,76);};
	CommonNormal()..{Text="0"; InitCommand=cmd(xy,ElementX,Top()+228+24*3+4*4;zoom,0.5;valign,0);};
	CommonNormal()..{Text="DEL"; InitCommand=cmd(xy,ElementX+52,Top()+228+24*3+4*4;zoom,0.5;valign,0);};
	
	CommonNormal()..{Text="DONE"; InitCommand=cmd(xy,ElementX-52,Top()+228+24*4+4*5;zoom,0.5;valign,0;maxwidth,76);};
	CommonNormal()..{Text=(SpeedMod == "X" and "." or "RANDOM"); InitCommand=cmd(xy,ElementX,Top()+228+24*4+4*5;zoom,0.5;valign,0;maxwidth,76);};
	CommonNormal()..{Text="BACK"; InitCommand=cmd(xy,ElementX+52,Top()+228+24*4+4*5;zoom,0.5;valign,0);};
}

return t